unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  UStruktura;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    btnCLOSE: TBitBtn;
    btnMakeFile: TBitBtn;
    btnWriteToFile: TBitBtn;
    btnReadFromFile: TBitBtn;
    btnFindInFile: TBitBtn;
    BtnAppend: TBitBtn;
    btnOpenFile: TBitBtn;
    Memo: TMemo;
    procedure BtnAppendClick(Sender: TObject);
    procedure btnFindInFileClick(Sender: TObject);
    procedure btnReadFromFileClick(Sender: TObject);
    procedure btnWriteToFileClick(Sender: TObject);
    procedure btnOpenFileClick(Sender: TObject);
    procedure btnMakeFileClick(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);
    procedure FormShow(Sender: TObject);

  private
	 procedure Utworz_plik();
	 procedure Otworz_plik();
	 procedure Zapis_do_pliku();
	 procedure Odczyt_z_pliku();
	 procedure Znajdz_w_pliku();
    procedure Dopisz_na_koncu();

  public

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}

procedure TMainForm.btnOpenFileClick(Sender: TObject);
begin
	Otworz_plik();
end;

procedure TMainForm.btnWriteToFileClick(Sender: TObject);
begin
	Zapis_do_pliku();
end;

procedure TMainForm.btnReadFromFileClick(Sender: TObject);
begin
	Odczyt_z_pliku();
end;

procedure TMainForm.BtnAppendClick(Sender: TObject);
begin
   Dopisz_na_koncu();
end;

procedure TMainForm.btnCLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.btnFindInFileClick(Sender: TObject);
begin
	Znajdz_w_pliku();
end;

procedure TMainForm.btnMakeFileClick(Sender: TObject);
begin
	Utworz_plik();
end;

procedure TMainForm.Utworz_plik();
var
	Rec : ROsoba;
   fh  : file of ROsoba;	// file handler - uchwyt pliku
   fn  : String;				// file name - nazwa pliku

begin
   // oczywicie nazwa pliku jest dowolna, tutaj jest to plik.rec
	fn := ExtractFilePath(Application.ExeName) + 'plik.rec';
	AssignFile(fh, fn);
   Rewrite(fh);
   CloseFile(fh);
end;

procedure TMainForm.FormShow(Sender: TObject);
var
	kom : String;
   rec : ROsoba;
   dl  : Integer;

   s     : String;
   poz : Integer;

begin
   Memo.Clear();
   Memo.Align := alClient;

	kom := 'rozmiar rekordu ROsoba = ' + IntToStr(sizeof(ROsoba));
	ShowMessage(kom);

	s   := 'Abc';
   poz := Pos('Cde', s);   // zmienna poz ma warto rwn 0
   ShowMessage('Indeks poszukiwanego cigu "Cde" = ' + IntToStr(poz));
end;

procedure TMainForm.Otworz_plik();
var
	Rec : ROsoba;
   fh  : file of ROsoba;	// file handler - uchwyt pliku
   fn  : String;				// file name - nazwa pliku

begin
	try
		fn := ExtractFilePath(Application.ExeName) + 'plik.rec';
		AssignFile(fh, fn);

      try
		   Reset(fh);
      	ShowMessage('Plik otwarty prawidowo');
   	except
      	ShowMessage('Nie udao si otworzy pliku');
      end;
   finally
   	// nie zapominamy o zamkniciu uchwytu do pliku
	   CloseFile(fh);
   end;
end;

procedure TMainForm.Zapis_do_pliku();
var
	Rec : ROsoba;
   fh  : file of ROsoba;	// file handler - uchwyt pliku
   fn  : String;				// file name - nazwa pliku

begin
   // wypeniamy bifor danych - nasz rekord
	rec.nazwisko       := 'Kowalska';
   rec.imie           := 'Ewelina';
   rec.ur_data        := StrToDate('1982-05-05');
   rec.ur_miasto      := 'Warszawa';
   rec.adres_kodp     := '02-796';
   rec.adres_miasto   := 'Warszawa';
   rec.adres_ulicainr := 'Jeewskiego 7/23';
   rec.grupa          := 1;	// oczywicie VIP

	try
		fn := ExtractFilePath(Application.ExeName) + 'plik.rec';
      // skojarzenie uchwytu pliku z nazw pliku
		AssignFile(fh, fn);
      // otwarcie pliku
      Reset(fh);

      try
         // zapis do pliku
         Write(fh, rec);
   	except
      	ShowMessage('Nie udao si wykona zapisu do pliku');
      end;
   finally
   	// nie zapominamy o zamkniciu uchwytu do pliku
	   CloseFile(fh);
   end;




	// zapisz dodatkowe rekordy do pliku
	fn := ExtractFilePath(Application.ExeName) + 'plik.rec';
	AssignFile(fh, fn);
   Reset(fh);

	rec.nazwisko       := 'Kowalska';
   rec.imie           := 'Anna';
   rec.ur_data        := StrToDate('1983-01-06');
   rec.ur_miasto      := 'Warszawa';
   rec.adres_kodp     := '02-796';
   rec.adres_miasto   := 'Warszawa';
   rec.adres_ulicainr := 'Jeewskiego 7/24';
   rec.grupa          := 1;
	Write(fh, rec);

	rec.nazwisko       := 'Kowalska';
   rec.imie           := 'Katarzyna';
   rec.ur_data        := StrToDate('1984-02-07');
   rec.ur_miasto      := 'Warszawa';
   rec.adres_kodp     := '02-796';
   rec.adres_miasto   := 'Warszawa';
   rec.adres_ulicainr := 'Jeewskiego 7/25';
   rec.grupa          := 1;
	Write(fh, rec);

	rec.nazwisko       := 'Kowalska';
   rec.imie           := 'Hanna';
   rec.ur_data        := StrToDate('1985-03-08');
   rec.ur_miasto      := 'Warszawa';
   rec.adres_kodp     := '02-796';
   rec.adres_miasto   := 'Warszawa';
   rec.adres_ulicainr := 'Jeewskiego 7/26';
   rec.grupa          := 1;
	Write(fh, rec);

	rec.nazwisko       := 'Brzczyszkiewicz';
   rec.imie           := 'Jacek';
   rec.ur_data        := StrToDate('1985-04-05');
   rec.ur_miasto      := 'Warszawa';
   rec.adres_kodp     := '02-796';
   rec.adres_miasto   := 'Warszawa';
   rec.adres_ulicainr := 'Jeewskiego 7/27';
   rec.grupa          := 3;
	Write(fh, rec);

	rec.nazwisko       := 'Kowalski';
   rec.imie           := 'Piotr';
   rec.ur_data        := StrToDate('1986-05-09');
   rec.ur_miasto      := 'Warszawa';
   rec.adres_kodp     := '02-796';
   rec.adres_miasto   := 'Warszawa';
   rec.adres_ulicainr := 'Jeewskiego 7/27';
   rec.grupa          := 1;
	Write(fh, rec);


   CloseFile(fh);
end;

procedure TMainForm.Odczyt_z_pliku();
var
	Rec : ROsoba;
   fh  : file of ROsoba;	// file handler - uchwyt pliku
   fn  : String;				// file name - nazwa pliku
   ss  : String;				// bufor na tekst

begin
   Memo.Clear();
   
	try
		fn := ExtractFilePath(Application.ExeName) + 'plik.rec';
      // skojarzenie uchwytu pliku z nazw pliku
		AssignFile(fh, fn);
      // otwarcie pliku
      Reset(fh);

      // dla wszystkich zapisw w pliku
      while not Eof(fh) do
      begin
         // wczytanie pojedyczego rekordu
      	Read(fh, rec);

         ss := rec.nazwisko           + ' ' +
               rec.imie               + ' ' +
               DateToStr(rec.ur_data) + ' ' +
               rec.ur_miasto          + ' ' +
               rec.adres_kodp         + ' ' +
               rec.adres_miasto       + ' ' +
               rec.adres_ulicainr     + ' ' +
               IntToStr(rec.grupa);

			// poka wynik w Memo
			Memo.Lines.Add(ss);
		end;
   finally
	   CloseFile(fh);
   end;
end;

procedure TMainForm.Znajdz_w_pliku();
var
	Rec         : ROsoba;
   fh          : file of ROsoba;	// file handler - uchwyt pliku
   fn          : String;			// file name - nazwa pliku
   ss          : String;			// bufor na tekst
   idx         : Integer;			// pozycja w pliku
   nazwisko    : String;	      // tego bdziemy szuka
   bZnalezione : Boolean;		   // wynik poszukiwania
   
begin
   Memo.Clear();

   bZnalezione := false;

   // takiego nazwiska bdziemy poszukiwa w pliku   
	nazwisko := 'Brzczyszkiewicz';

	try
		fn := ExtractFilePath(Application.ExeName) + 'plik.rec';
      // skojarzenie uchwytu pliku z nazw pliku
		AssignFile(fh, fn);

      // otwarcie pliku
      Reset(fh);

      idx := 0;

      // dla wszystkich zapisw w pliku
      while not Eof(fh) do
      begin
      	Inc(idx);

         // wczytanie pojedyczego rekordu
      	Read(fh, rec);

         if rec.nazwisko = nazwisko then
         begin
            bZnalezione := true;

            ss := rec.nazwisko           + ' ' +
                  rec.imie               + ' ' +
                  DateToStr(rec.ur_data) + ' ' +
                  rec.ur_miasto          + ' ' +
                  rec.adres_kodp         + ' ' +
                  rec.adres_miasto       + ' ' +
                  rec.adres_ulicainr     + ' ' +
                  IntToStr(rec.grupa);

				// poka w Memo
				Memo.Lines.Add(ss);
         end;
		end;
   finally
	   CloseFile(fh);
   end;

   if bZnalezione then
   begin
		Memo.Lines.Add('Indeks rekordu = ' + IntToStr(idx));
   end
   else begin
		Memo.Lines.Add('Poszukiwany cig nie zosta znaleziony');
   end;
end;

procedure TMainForm.Dopisz_na_koncu();
var
	Rec : ROsoba;
   fh  : file of ROsoba;	// file handler - uchwyt pliku
   fn  : String;				// file name - nazwa pliku
   ss  : String;				// bufor na tekst

   iSize : Integer;        // rozmiar piku

begin
   Memo.Clear();

   // wypeniamy bifor danych - nasz rekord
	rec.nazwisko       := 'Bednarska';
   rec.imie           := 'Ewa';
   rec.ur_data        := StrToDate('1990-01-01');
   rec.ur_miasto      := 'Warszawa';
   rec.adres_kodp     := '02-796';
   rec.adres_miasto   := 'Warszawa';
   rec.adres_ulicainr := 'Jeewskiego 8/1';
   rec.grupa          := 2;

	try
		fn := ExtractFilePath(Application.ExeName) + 'plik.rec';
      // skojarzenie uchwytu pliku z nazw pliku
		AssignFile(fh, fn);
      // otwarcie pliku
      Reset(fh);
      iSize := FileSize(fh);

      Seek(fh, iSize);

      // dopisz na kocu pliku
      Write(fh, rec);
      Memo.Lines.Add('Dopisano na kocu pliku rekord z osob onazwisku Benarska');
   finally
	   CloseFile(fh);
   end;
end;

end.

